//
//  OnlineOTPViewController.swift
//  Demo iOS
//
//  Created by Benoit Vasseur on 06/07/2022.
//

import UIKit

class OnlineOTPViewController: BaseViewController {

    @IBOutlet weak var pinField: UITextField!
    @IBOutlet weak var containerView: UIView!
    @IBOutlet weak var pinView: UIView!
    
    @IBOutlet weak var resultContainerView: UIView!
    @IBOutlet weak var otpText: UILabel!
    
    
    override func viewDidLoad() {
        super.viewDidLoad()
        
        self.title = "Online OTP"
        
        containerView.isHidden = true
        resultContainerView.isHidden = true

        startOtpProcess()
    }
    
    func startOtpProcess() {
        DispatchQueue.global().async {
            let result = InweboService.sharedInstance.startOnlineOTPGenerationProcess()
            DispatchQueue.main.async {
                if result == IW_ERR_OK {
                    self.containerView.isHidden = false
                    let pinMode = InweboService.sharedInstance.getPinMode()
                    self.pinView.isHidden = pinMode == IW_PINMODE_NONE
                } else {
                    self.showErrorFor(code: result)
                    self.navigationController?.popViewController(animated: true)
                }
            }
        }
    }
    
    func finalizeOtpProcess(pin: String) {
        DispatchQueue.global().async {
            let result = InweboService.sharedInstance.finalizeOnlineOTPGenerationProcess(pin: pin)
            DispatchQueue.main.async {
                if result == IW_ERR_OK {
                    self.otpText.text = InweboService.sharedInstance.getOnlineOtpAnswer()
                    self.resultContainerView.isHidden = false
                } else {
                    self.showErrorFor(code: result)
                }
            }
        }
    }
    
    @IBAction func generateTouched(_ sender: Any) {
        let pinMode = InweboService.sharedInstance.getPinMode()
        
        if pinMode == IW_PINMODE_NONE {
            finalizeOtpProcess(pin: "")
        } else if (pinMode & IW_PINMODE_CURRENT) != 0 {
            finalizeOtpProcess(pin: self.pinField.text ?? "")
        }
    }
    
    @IBAction func copyTouched(_ sender: Any) {
        UIPasteboard.general.string = otpText.text
    }
    
}
